<!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Optional Bootstrap JS and Popper (if needed) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card shadow rounded-4">
                <div class="card-header bg-primary text-white text-center rounded-top-4">
                    <h2 class="mb-0">💳 Make a Payment</h2>
                </div>
                <div class="card-body p-4">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            {{ $errors->first() }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('payment.initiate') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="amount" class="form-label fw-semibold">Amount (PKR)</label>
                            <input type="number" name="amount" class="form-control" id="amount" step="0.01" required>
                        </div>

                        <div class="mb-4">
                            <label for="order_name" class="form-label fw-semibold">Order Description</label>
                            <input type="text" name="order_name" class="form-control" id="order_name" required>
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg rounded-pill">
                                Proceed to Payment
                            </button>
                        </div>
                    </form>

                    <hr class="my-4">

                    <div>
                        <h5 class="fw-bold">🧪 Test Card Details:</h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item">Card Number: <strong>4111 1111 1111 1111</strong> (Visa)</li>
                            <li class="list-group-item">Expiry: <strong>Any future date</strong></li>
                            <li class="list-group-item">CVV: <strong>123</strong></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
