<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class FetchTokenTransactionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'plot_no' => $this->plot_id,
            'amount' => number_format($this->amount),
            'transaction_date' => Carbon::parse($this->transaction_date)->format('d M Y'),
            'client_name' => $this->Cust_Name,
        ];
    }
}