<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SliderController extends Controller
{
    public function store(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'img' => 'required|image',
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }
    
      
        $slider = new Slider();
        $slider->title = $request->title;
    
        if ($request->hasFile('img')) {
            $img_1 = $request->file('img');
            $imageName_1 = uniqid('img').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('slider-images'), $imageName_1);
            $slider->img= url('public/slider-images/'.$imageName_1);
        }

        if($slider->save())
        {
            return response()->json([
                'message' => 'record created successfully'
            ],201);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    
       
    }

    public function get(Request $request , $id = null)
    {
        $status = is_null($request->status) ? "deleted" : $request->status;

        $data = Slider::orderBy('id' , 'asc');
        if($status  == "deleted")
        {
            $data = $data->where('status' , '<>' ,'deleted');
        }else{
            $data  = $data->where('status' , $data);
        }
        if(!is_null($id))
        {
            $data = $data->where('id' , $id);
        }
        $data = $data->get();

        if($data->isNotEmpty())
        {
             return response()->json([
                'data' => $data
             ],200);
        }else{
            return response()->json([
               'message' => 'no record found !'
            ],404);
        }        
    }

    public function update(Request $request , $id)
    {
        $validation = Validator::make($request->all(), [
            'title' => 'required',
            'img' => 'nullable|image',
        ]);
        
        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed !',
                'errors' => $validation->errors(),
            ], 422);
        }

        $slider = Slider::find($id);

        if(!$slider)
        {
            return response()->json([
                'message' => 'no record found !'
            ],404);
        }

        $slider->title = $request->title;
    
        if ($request->hasFile('img')) {
            $img_1 = $request->file('img');
            $imageName_1 = uniqid('img').'.'.$img_1->getClientOriginalExtension();
            $img_1->move(public_path('slider-images'), $imageName_1);
            $slider->img= url('public/slider-images/'.$imageName_1);
        }

        if($slider->save())
        {
            return response()->json([
                'message' => 'record updated successfully'
            ],201);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    }

    public function changeStatus($id , $status)
    {
        $slider = Slider::find($id);
        if(!$slider){
            return response()->json([
               'message' => 'no record found !'
            ],404);
        }

        $validStatuses = ['active', 'inactive', 'deleted'];
        if (!in_array($status, $validStatuses)) {
            return response()->json([
                'message' => 'Invalid status'
            ], 422);
        }

        $slider->status = $status;
        if($slider->save())
        {
            return response()->json([
                'message' => 'change status successfully'
            ],200);
        }else{
            return response()->json([
                'message' => 'something went wrong , try again !'
            ],400);
        }
    }

  
}
