<?php

namespace App\Http\Controllers;

use App\Models\SaleDeedMain;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SaleDeedMainController extends Controller
{
    use ApiResponseTrait;

    public function serverRecord()
    {
        $data = SaleDeedMain::select('HSD_ID as id')->get();
        if ($data->isEmpty()) {
            return $this->recordNotFoundResponse();
        } else {
            return $this->recordFoundResponse($data);
        }
    }
    public function store(Request $request)
    {
        try {
            $stored = SaleDeedMain::insert($request->all());
            if ($stored) {
                return $this->successInsertResponse($stored);
            } else {
                return $this->errorInsertResponse();
            }

        } catch (\Exception $e) {

            return response()->json(['error' => 'Something went wrong while storing data' . $e], 500);
        }
    }
    public function editbySql(Request $request)
    {
        $successCount = 0;
        $totalCount = count($request->data);

        //  print_r($request->all());
        foreach ($request->data as $arr) {
            $result = DB::table('Housing_Sale_Deed_Main')
                ->where('HSD_ID', $arr['HSD_ID'])
                ->update([
                    'HSD_ID' => $arr['HSD_ID'],
                    'Comp_ID' => $arr['Comp_ID'],
                    'Ledger_ID' => $arr['Ledger_ID'],
                    'Cust_ID' => $arr['Cust_ID'],
                    'Project_ID' => $arr['Project_ID'],
                    'UP_ID' => $arr['UP_ID'],
                    // 'Agree_Date' => $arr['Agree_Date']->format('Y-m-d'),
                    'Cust_Token' => $arr['Cust_Token'],
                    'Cust_Bal' => $arr['Cust_Bal'],
                    'Adj_Bal' => $arr['Adj_Bal'],
                    'Other_Charges' => $arr['Other_Charges'],
                    'Total_Marla' => $arr['Total_Marla'],
                    'Per_Marla_Price' => $arr['Per_Marla_Price'],
                    'LS_Disc' => $arr['LS_Disc'],
                    'Total_Price' => $arr['Total_Price'],
                
                    'SP_ID' => $arr['SP_ID'],
                    'RP_ID' => $arr['RP_ID'],
                    'Affilate_ID' => $arr['Affilate_ID'],
                    'Down_Pay_Per' => $arr['Down_Pay_Per'],
                    'Down_Pay_Amt' => $arr['Down_Pay_Amt'],
                    // 'Down_Due_Date' => $arr['Down_Due_Date']->format('Y-m-d'),

                    'On_Poss_Per' => $arr['On_Poss_Per'],
                    // 'Poss_Due_Date' => $arr['Poss_Due_Date']->format('Y-m-d'),
                    // 'Inst_Start_Date' => $arr['Inst_Start_Date']->format('Y-m-d'),
                    'STTC_Detail' => $arr['STTC_Detail'],
                    'Cancelled_By' => $arr['Cancelled_By'],
                    // 'Cancelled_On' => $arr['Cancelled_On']->format('Y-m-d'),

                    'User_ID' => $arr['User_ID'],
                    // 'Created_On' => $arr['Created_On']->format('Y-m-d'),
                    'Cancel_Type' => $arr['Cancel_Type'],
                    'Cancel_Ledger_ID' => $arr['Cancel_Ledger_ID'],
                    'Cancel_Amt' => $arr['Cancel_Amt'],
                    'Cancel_Reason' => $arr['Cancel_Reason'],
                    'Current_Cust_ID' => $arr['Current_Cust_ID'],
                ]);
            if ($result !== false) {
                $successCount++;
            }
        }

        if ($successCount === $totalCount) {
            return $this->successUpdateResponse("All records updated successfully.");
        } else {
            return $this->errorUpdateResponse("Failed to update some records.");
        }
    }
}
