<?php

namespace App\Http\Controllers;

use App\Http\Requests\PaymentRequest;
use App\Http\Resources\FetchTokenTransactionResource;
use App\Http\Resources\PaymentIndexResource;
use App\Mail\PaymentMail;
use App\Models\Payment;
use App\Models\CsParty;
use App\Models\Housing_Sale_Inst_Pay_Main;
use App\Models\HousingSaleInstPayChil;
use App\Models\HousingSaleTokenChill;
use App\Models\HousingSaleTokenMain;
use App\Models\HousingUnitPlot;
use App\Models\LedgerDetail;
use App\Models\LedgerMain;
use App\Models\SaleDeedIns;
use App\Models\SaleDeedMain;
use App\Models\Transaction;
use App\Traits\ApiResponseTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Stripe\Stripe;
use Stripe\Charge;
use App\Models\Account;
use App\Notifications\PaymentNotification;
use Illuminate\Support\Facades\Notification;

class PaymentController extends Controller
{
    use ApiResponseTrait;

    private $epgUrl = 'https://ipg.comtrust.ae:2443';
    private $customer = 'CANAL PALMS';
    private $username = 'CANAL_Hassan';
    private $password = 'M3vJ/^?53\S:36%yQ7#@';
    private $store = '0000';
    private $terminal = '0000';
    private $currency = 'PKR';
    private $channel = 'Web';
    private $transactionHint = 'CPT:Y;VCC:Y;';

    /**
     * Work Flow of Plots recrd Api
     * Housing sale deed main table is joined based on 
     */

     public function initiatePaymentApi(Request $request)
     {
        
          $validation = Validator::make($request->all(), [
            'amount' => 'required|numeric|min:0.01',
             'order_name' => 'required|string|max:255'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }
 
         // Generate 16-digit numeric OrderID
         $orderID = substr(date('YmdHis') . mt_rand(1000, 9999), 0, 16);
 
         $registrationData = [
             'Registration' => [
                 'Customer' => 'CANAL PALMS',
                 'Currency' => 'PKR',
                 'ReturnPath' => 'https://canalpalms.com/payment/callback', 
                 'TransactionHint' => 'CPT:Y;VCC:Y;',
                 'OrderID' => $orderID,
                 'Store' => '0000',
                 'Terminal' => '0000',
                 'Channel' => 'Web',
                 'Amount' => $request->amount,
                 'OrderName' => $request->order_name,
                 'UserName' => 'CANAL_Hassan',
                 'Password' => 'M3vJ/^?53\S:36%yQ7#@'
             ]
         ];
 
         try {
             $response = Http::withoutVerifying()
                 ->withHeaders([
                     'Content-Type' => 'application/json',
                     'Accept' => 'application/json'
                 ])
                 ->post($this->epgUrl, $registrationData);
 
             if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                 if ($response['Transaction']['ResponseCode'] === '0') {
                     return response()->json([
                         'payment_url' => $response['Transaction']['PaymentPortal'],
                         'transaction_id' => $response['Transaction']['TransactionID']
                     ]);
                 }
                 return response()->json([
                     'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment initiation failed'
                 ], 400);
             }
 
             return response()->json(['error' => 'Payment gateway connection failed'], 500);
 
         } catch (\Exception $e) {
             Log::error('EPG Error: ' . $e->getMessage());
             return response()->json(['error' => 'Payment service unavailable'], 503);
         }
    }

    public function handleCallbackApi(Request $request)
    {
        // Validate request
        $validation = Validator::make($request->all(), [
            'amount'        => 'required|numeric',
            'customer_id'   => 'required|numeric',
            'plot_id'       => 'required',
            'TransactionID' => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'Validation failed!',
                'errors'  => $validation->errors(),
            ], 422);
        }

        DB::beginTransaction();

        $transactionId = $request->input('TransactionID');

        // Prepare request for finalization API
        $finalizationData = [
            'Finalization' => [
                'TransactionID' => $transactionId,
                'Customer'      => 'CANAL PALMS',
                'UserName'      => 'CANAL_Hassan',
                'Password'      => 'M3vJ/^?53\S:36%yQ7#@'
            ]
        ];

        try {
            $response = Http::withoutVerifying()
                ->withHeaders([
                    'Content-Type' => 'application/json',
                    'Accept'       => 'application/json'
                ])
                ->post($this->epgUrl, $finalizationData);

             $customer = CsParty::find($request->customer_id);
             $accountLid = $customer->Cust_No;

            // Validate payment response
            if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                if ($response['Transaction']['ResponseCode'] === '0') {

                    // Common values
                    $btnNo      = 'TKN';
                    $createdOn  = now();
                    // $amount     = $request->amount;
                    $amount = floatval($request->amount);
                    // $amount = floatval(5);

                    $userId = '1000';

                    // Create Ledger Main
                    $ledgerMain = LedgerMain::create([
                        'Ledger_ID' => (LedgerMain::max('Ledger_ID') ?? 0) + 1,
                        'Comp_ID'   => 16,
                        'Acco_LID'  => $accountLid,
                        'L_Amount'  => $amount,
                        'User_ID'   => $userId,
                        'BT_No'     => $btnNo,
                        'L_Date'    => $createdOn,
                        'Per_ID'    => '0',
                        'Descr' => '',
                        'Created_On' =>0,
                        'Posted_By' =>0,
                        'Posted_On' => 0,
                        'Cancelled_By' => 0,
                        'Cancelled_On' =>0
                    ]);

                    // Create Ledger Details (Debit & Credit)
                    foreach ([
                        ['Debit' => $amount, 'Credit' => 0], // Debit
                        ['Debit' => 0, 'Credit' => $amount]  // Credit
                    ] as $detail) {
                        LedgerDetail::create([
                            'Ledger_ID'     => $ledgerMain->Ledger_ID,
                            'Comp_ID'       => 16,
                            'BT_No'         => $btnNo,
                            'Acco_LID'      => $accountLid,
                            'R_Acco_LID'    => '2000.2.2.1.1',
                            'Debit'         => $detail['Debit'],
                            'Credit'        => $detail['Credit'],
                            'L_Remarks'     => 'N/A',
                            'L_QTY'         => '0.0000',
                            'Accrual_Date'  => $createdOn,
                        ]);
                    }

                    // Create Token
                    $tokenId = (HousingSaleTokenMain::where('Comp_ID', 16)->max('Token_ID') ?? 0) + 1;

                    HousingSaleTokenMain::create([
                        'Token_ID'     => $tokenId,
                        'Comp_ID'      => 16,
                        'Ledger_ID'    => $ledgerMain->Ledger_ID,
                        'Cust_ID'      => $accountLid,
                        'Token_Amt'    => $amount,
                        'T_Date'       => $createdOn,
                        'Valid_Date'   => $createdOn,
                        'Pay_Acco'     => $accountLid,
                        'T_Detail'     => 'N/A',
                        'SP_ID'        => $accountLid,
                        'RP_ID'        => $accountLid,
                        'Affilate_ID'  => $accountLid,
                        'CNIC_No'      => $customer->NIC_No,
                        'Adj_Token' => 0,
                        'Cancelled_By' => 0,
                        'Cancelled_By' => 0,
                        'Cancel_Ledger_ID' => 0,
                        'Cancel_Amt' => 0,
                        'Cancel_Reason' =>"",
                        'Cancel_L_Remarks' => "",
                        'Receipt_Booking' => 0,
                        'Nomi_Name' =>  "",
                        'Passport_No' => "",
                        'Son_Of' => "",
                        'Addr1' => "",
                        'Mob_No' => "",
                        'Relation_Ship' => "",
                        'Nomi_Pic' => null,
                        'Total_Price'=> 0
                    ]);


                    HousingSaleTokenChill::create([
                        'Token_ID'   => $tokenId,
                        'Comp_ID'    => 16,
                        'Project_ID' => '2000.2.1.6.8',
                        'UP_ID'      => $request->plot_id,
                        'L_Remarks' => ''
                    ]);

                    // Update Plot Status
                    HousingUnitPlot::where('UP_ID', $request->plot_id)
                        ->update(['UP_Status' => 'TOKEN']);
                        
                        
                        // Mail Sending Code
                        //  try {
                        //         $accountData = Account::where('Acco_LID', $request->plot_id)->first();
                        //         $plotName = $accountData?->Acco_Name ?? $request->input('plot_name');
            
                        //         $customerData = (object) [
                        //             'name'           => $customer->Name,
                        //             'E_Mail'         => $customer->E_Mail,
                        //             'Mob_No'         => $customer->Mob_No,
                        //             'NIC_No'         => $customer->NIC_No,
                        //             'Cust_No'        => $customer->Cust_No,
                        //             'Plot_Name'      => $plotName ? $plotName . ', Phase 4' : 'N/A',
                        //             'amount'         => $amount,
                        //             'transaction_id' => $transactionId,
                        //             'paid_date'      => now()->format('d M Y, h:i A'),
                        //         ];
                        //         // Customer email
                        //         if (!empty($customerData->E_Mail)) {
                        //             Notification::route('mail', $customerData->E_Mail)
                        //                 ->notify(new PaymentNotification($customerData));
                        //         }
            
                        //         // Team emails
                        //         $teamEmails = [
                        //             'payments@canalpamls.com',
                        //             'fc@canalpamls.com',
                        //             'gmsales@canalpamls.com',
                        //         ];
            
                        //         foreach ($teamEmails as $email) {
                        //             Notification::route('mail', $email)
                        //                 ->notify(new PaymentNotification($customerData));
                        //         }
                        // } catch (\Exception $e) {
                        //     Log::warning("Failed to send payment notifications: {$e->getMessage()}");
                        // }
                        

                    // Send Email
                    // try {
                    //     Mail::to($customer->E_Mail)->send(new PaymentMail($customer));
                    // } catch (\Exception $e) {
                    //     Log::warning("Failed to send payment mail: {$e->getMessage()}");
                    // }

                    // Success Response
                    
                    // ...
                    
                    // Track email status
                    $emailStatus = [
                        'customer' => 'not_sent',
                        'team'     => []
                    ];
                    
                    // Mail Sending Code
                    try {
                        $accountData = Account::where('Acco_LID', $request->plot_id)->first();
                        $plotName = $accountData?->Acco_Name ?? $request->input('plot_name');
                    
                        $customerData = (object) [
                            'name'           => $customer->Cust_Name,
                            'E_Mail'         => $customer->E_Mail,
                            'Mob_No'         => $customer->Mobi,
                            'NIC_No'         => $customer->NIC_No,
                            'Cust_No'        => $customer->Cust_No,
                            'Plot_Name'      => $plotName ? $plotName . ', Phase 4' : 'N/A',
                            'amount'         => $amount,
                            'transaction_id' => $transactionId,
                            'paid_date'      => now()->format('d M Y, h:i A'),
                        ];
                    
                        // Customer email
                        if (!empty($customer->E_Mail)) {
                            try {
                                 Mail::to($customer->E_Mail)->send(new PaymentMail($customer));

                              
                                $emailStatus['customer'] = 'success';
                            } catch (\Exception $e) {
                                $emailStatus['customer'] = 'failed';
                                Log::warning("Failed to send customer email: {$e->getMessage()}");
                            }
                        }
                    
                        // Team emails
                        $teamEmails = [
                            'gmsales@canalpalms.com',
                            'fc@canalpalms.com',
                            'payments@canalpalms.com',
                        ];
                    
                        foreach ($teamEmails as $email) {
                            try {
                                Notification::route('mail', $email)
                                    ->notify(new PaymentNotification($customerData));
                                $emailStatus['team'][$email] = 'success';
                            } catch (\Exception $e) {
                                $emailStatus['team'][$email] = 'failed';
                                Log::warning("Failed to send team email to {$email}: {$e->getMessage()}");
                            }
                        }
                    } catch (\Exception $e) {
                        Log::warning("Mail sending block failed: {$e->getMessage()}");
                    }


                   
                    DB::commit();
                    return response()->json([
                        'status'         => 'success',
                        'amount'         => $response['Transaction']['Amount']['Value'],
                        'approval_code'  => $response['Transaction']['ApprovalCode'],
                        'card_number'    => $response['Transaction']['CardNumber'],
                        'transaction_id' => $transactionId,
                        'message'        => 'Payment success',
                        'emails'         => $emailStatus,
                        'data' => $customerData,
                    ]);
                   
                }

                // Payment Failed
                DB::rollBack();
                return response()->json([
                    'status' => 'failed',
                    'error'  => $response['Transaction']['ResponseDescription'] ?? 'Payment failed'
                ], 400);
            }

            return response()->json(['status' => 'error', 'error' => 'Payment verification failed'], 500);

        } catch (\Exception $e) {
            Log::error('EPG Finalization Error: ' . $e->getMessage());
            return response()->json(['status' => 'error', 'error' => 'Payment service unavailable'], 503);
        }
    }

    public function payInstallmentInitiate(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'amount' => 'required|numeric|min:0.01',
            'installment_no' => 'required|string|max:255'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }
 
        // Generate 16-digit numeric OrderID
        $orderID = substr(date('YmdHis') . mt_rand(1000, 9999), 0, 16);
 
        $registrationData = [
            'Registration' => [
                'Customer'          => 'CANAL PALMS',
                'Currency'          => 'PKR',
                'ReturnPath'        => 'https://canalpalms.com/payment/callback', 
                'TransactionHint'   => 'CPT:Y;VCC:Y;',
                'OrderID'           => $orderID,
                'Store'             => '0000',
                'Terminal'          => '0000',
                'Channel'           => 'Web',
                'Amount'            => $request->amount,
                'OrderName'         => $request->installment_no,
                'UserName'          => 'CANAL_Hassan',
                'Password'          => 'M3vJ/^?53\S:36%yQ7#@'
            ]
        ];
 
        try {
            $response = Http::withoutVerifying()
                ->withHeaders([
                    'Content-Type'  => 'application/json',
                    'Accept'        => 'application/json'
                ])
                ->post($this->epgUrl, $registrationData);
 
            if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                if ($response['Transaction']['ResponseCode'] === '0') {
                    return response()->json([
                        'payment_url' => $response['Transaction']['PaymentPortal'],
                        'transaction_id' => $response['Transaction']['TransactionID']
                    ]);
                }

                return response()->json([
                    'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment initiation failed'
                ], 400);
            }

            return response()->json(['error' => 'Payment gateway connection failed'], 500);
        } catch (\Exception $e) {
            Log::error('EPG Error: ' . $e->getMessage());
            return response()->json(['error' => 'Payment service unavailable'], 503);
        }
    }

    public function payInstallmentCallback(Request $request)
    {
        $validation = Validator::make($request->all(), [
            'TransactionID' => 'required',
            'amount'        => 'required',
            'id'            => 'required',
            'description'   => 'required',
            'due_date'      => 'required',
            'UP_ID'         => 'required',
            'inst_id'       => 'required',
            'customer_id'   => 'required'
        ]);

        if ($validation->fails()) {
            return response()->json([
                'message' => 'validation failed!',
                'errors' => $validation->errors(),
            ], 422);
        }
                DB::beginTransaction();


        $transactionId = $request->input('TransactionID');
        $finalizationData = [
            'Finalization' => [
                'TransactionID' => $transactionId,
                'Customer' => 'CANAL PALMS',
                'UserName' => 'CANAL_Hassan',
                'Password' => 'M3vJ/^?53\S:36%yQ7#@'
            ]
        ];

        try {
           $response = Http::withoutVerifying()
            ->withHeaders([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json'
            ])
            ->post($this->epgUrl, $finalizationData);

            $customer = CsParty::find($request->customer_id);
            $accountLid = $customer->Cust_No;
            // return $customer;

            if ($response->successful() && isset($response['Transaction']['ResponseCode'])) {
                if ($response['Transaction']['ResponseCode'] === '0') {
                    try {
                        $userId = '1000';
                        $btnNo = 'HTN';
                        $createdOn = date("Y-m-d H:i:s");
                        $compID = 16;
                        $maxLedgerId = LedgerMain::where('Comp_ID', $compID)->max('Ledger_ID');
                        $newLedgerId = ($maxLedgerId ?? 0) + 1;
                        
                        

                        // Create Ledger Main
                        // DB::enableQueryLog();
                        $ledgerMain = LedgerMain::create([
                            'Ledger_ID' => $newLedgerId,
                            'Comp_ID'   => $compID,
                            'Acco_LID'  => $accountLid,
                            'L_Amount'  => $request->amount,
                            'User_ID'   => $userId,
                            'BT_No'     => $btnNo,
                            'L_Date'    => $createdOn,
                            'Per_ID'    => 'N/A',
                        ]);
                        // return DB::getQueryLog();

                        // Create Ledger Details (Debit & Credit)
                        foreach ([
                            ['Debit' => $request->amount, 'Credit' => 0], // Debit
                            ['Debit' => 0, 'Credit' => $request->amount]  // Credit
                        ] as $detail) {
                            LedgerDetail::create([
                                'Ledger_ID'     => $ledgerMain->Ledger_ID,
                                'Comp_ID'       => $compID,
                                'BT_No'         => $btnNo,
                                'Acco_LID'      => $accountLid,
                                'R_Acco_LID'    => '2000.2.2.1.1',
                                'Debit'         => $detail['Debit'],
                                'Credit'        => $detail['Credit'],
                                'L_Remarks'     => 'N/A',
                                'L_QTY'         => '0.0000',
                                'Accrual_Date'  => $createdOn,
                            ]);
                        }

                        $maxInstId = Housing_Sale_Inst_Pay_Main::where('Comp_ID', 16)->max('Inst_ID');
                        $instId = ($maxInstId ?? 0) + 1;

                        Housing_Sale_Inst_Pay_Main::create([
                            'Inst_ID' => $instId,
                            'Comp_ID' => $compID,
                            'Ledger_ID' => $ledgerMain->Ledger_ID,
                            'I_Date' => $createdOn,
                            'Cust_ID' => $accountLid,
                            'Project_ID' => '2000.2.1.6.8',
                            'UP_ID' => $request->UP_ID,
                            'Inst_Amt' => $request->amount,
                            'Cancel_Status' => '0',
                            'PDC_ID' => '0',
                            'HSD_ID' => '0',
                        ]);

                        HousingSaleInstPayChil::create([
                            'Inst_ID' => $instId,
                            'Comp_ID' => $compID,
                            'Installments' => $request->description,
                            'Due_Date' => $request->due_date,
                            'I_Amount' => $request->amount,
                            'Token_Amt' => '0.00',
                            'Adj_Token' => '0.00',
                            'Paid_Amt' => $request->amount,
                            'Paid_on' => $createdOn,
                            'Pay_Due_Descr' => $request->description,
                            'Pay_Acco' => $accountLid,
                            'Pay_Detail' => $request->description,
                            'Sp_Disc' => '0.00',
                            'Sur_Charge' => '0.00',
                            'Reason' => 'N/A',
                            'OutStanding' => '0.00',
                            'Inst_Status' => 'FULL',
                            'L_Remarks' => $request->description,
                            'Inst_Arrears' => 0.0,
                        ]);
                                
                        DB::commit();
                        return response()->json([
                            'status'        => 'success',
                            'amount'        => $response['Transaction']['Amount']['Value'],
                            'approval_code' => $response['Transaction']['ApprovalCode'],
                            'card_number'   => $response['Transaction']['CardNumber'],
                            'transaction_id'=> $transactionId
                        ]);


                       
                    } catch (\Exception $e) {
                        return $this->errorInsertResponse();
                    }

                }
                  DB::rollBack();

                return response()->json([
                    'status' => 'failed',
                    'error' => $response['Transaction']['ResponseDescription'] ?? 'Payment failed'
                ], 400);
            }

            return response()->json(['status' => 'error', 'error' => 'Payment verification failed'], 500);
        } catch (\Exception $e) {
            Log::error('EPG Finalization Error: ' . $e->getMessage());
            return response()->json(['status' => 'error', 'error' => 'something weng wrong'], 400);
        }
    }

    public function store(PaymentRequest $request)
    {
        $saved = Payment::create($request->validated());
        return $saved ? $this->successInsertResponse($saved) : $this->errorInsertResponse();
    }

    

    private function convertCurrency($amount)
    {
        $url = 'https://marketdata.tradermade.com/api/v1/convert';
        $params = [
            'from' => 'PKR',
            'to' => 'USD',
            'amount' => $amount,
            'api_key' => 'l3PEOIdg-QIuyvNr2SzV'
        ];

        $response = Http::withOptions([
            'verify' => false,
        ])->get($url, $params);

        $data = $response->json();
        return ($response->successful()) ? $data['total'] : 1;
    }

    protected function softDelete($id = null)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422); // HTTP 422 Unprocessable Entity
        }

        $record = Payment::find($id);

        if (!$record)
            return response()->json([
                'message' => 'Record not found'
            ], 404); // HTTP 404 Not Found


        $record->delete();
        return response()->json([
            'message' => 'Record successfully soft deleted'
        ], 200); // HTTP 200 OK
    }

    protected function index()
    {
        return Payment::all();
    }

    protected function indexV1(Request $request)
    {
        $limit = $this->setDefaultValue($request->limit, DEFAULT_LIMIT);
        $traStartDate = $this->setDefaultValue($request->tra_start_date);
        $traEndDate = $this->setDefaultValue($request->tra_end_date);
        $dueStartDate = $this->setDefaultValue($request->due_start_date);
        $dueEndDate = $this->setDefaultValue($request->due_end_date);
        $plotId = $this->setDefaultValue($request->plot_id);
        $csParty = $this->setDefaultValue($request->csparty_id);


        $data = Payment::with('client:id,Cust_Name,NIC_No')
            ->filterByTransactionDate($traStartDate, $traEndDate)
            ->filterByDueDate($dueStartDate, $dueEndDate)
            ->wherePlot($plotId)
            ->whereCsParty($csParty)
            ->orderByDesc('id')
            ->paginate($limit);


        $pagination = [
            'page' => $data->currentPage(),
            'total_record' => $data->total(),
            'limit' => $limit,
            'total_pages' => ceil($data->total() / $limit),
        ];

        return $data->isEmpty()
            ? $this->recordNotFoundResponse()
            : $this->recordFoundResponse(PaymentIndexResource::collection($data->items()), 200, $pagination);
    }

    protected function showV1($id)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422); // HTTP 422 Unprocessable Entity
        }


        $data = Payment::with('client:id,Cust_Name,NIC_No')
            ->whereId($id)
            ->first()
        ;

        return $data
            ? $this->recordFoundResponse(PaymentIndexResource::make($data))
            : $this->recordNotFoundResponse();

    }

    protected function show($id)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => 'required|integer'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validation error',
                'errors' => $validator->errors()
            ], 422); // HTTP 422 Unprocessable Entity
        }

        $record = Payment::find($id);

        if (!$record)
            return response()->json([
                'message' => 'Record not found'
            ], 404); // HTTP 404 Not Found

        return $this->recordFoundResponse($record);
    }

    public function transaction($customerId, $amount)
    {
        $transaction = new Transaction();
        $transaction->customer_id = $customerId;
        $transaction->amount = $amount;
        $transaction->save();
    }

    public function fetchPayment() //used on local server
    {
        $data = Payment::select(
            'payments.plot_id as plot_no',
            'payments.csparty_id as csparty_id',
            'payments.amount',
            'payments.id as transactionId',
            'csparty.*'
        )
            ->leftJoin('csparty', 'payments.csparty_id', 'csparty.id')
            ->where('payments.transaction_category', 'token')
            ->where('is_updateable', '1')->limit(1)->get();
        if (!$data->isEmpty()) {
            return response()->json([
                'data' => $data,
            ], 200);
        } else {
            return response()->json([
                'message' => 'no record found!',
            ], 404);
        }
    }

    public function changeUpdatedStatus(Request $request) // used on local server
    {
        try {
            $customer = CsParty::find($request->cust_id);
            $customer->Cust_No = $request->cust_no;
            $customer->save();
        } catch (\Exception $e) {
             
        }

        // dd($request);
        $ids = $request->update_id;
        $execute = Payment::whereIn('id', $ids)->update(['is_updateable' => '0']);

        if (!is_null($request->plot_no)) {
            $update = $this->changeStatusPlot($request->plot_no);
        }

        if ($update) {
            return $execute ? $this->successUpdateResponse($ids) : $this->errorUpdateResponse();
        }
    }

    public function changeStatusPlot($plotIds)
    {
        $query = DB::table('housing_unit_plots')
            ->whereIn('UP_ID', $plotIds)
            ->update(['UP_Status' => 'TOKEN']);

        if ($query) {
            return response()->json([
                'message' => 'Plot Status Changes Successfully'
            ], 200);
        } else {
            return response()->json([
                'message' => 'Something Went Wrong Try Again!'
            ], 400);
        }
    }

    protected function payInstallment(Request $request) // for pay installment (not in use)
    {
        try {

            $validation = Validator::make($request->all(), [
                'amount' => 'required',
                'token' => 'required',
                'id' => 'required',
                'description' => 'required',
                'due_date' => 'required',
                'UP_ID' => 'required',
                'inst_id' => 'required|exists:Housing_Sale_Deed_Ins,ID'
            ]);
            if ($validation->fails()) {
                return response()->json([
                    'message' => 'validation failed',
                    'errors' => $validation->errors(),
                ], 422);
            }

            Stripe::setApiKey(env('STRIPE_SECRET'));

            $amount = ceil($this->convertCurrency($request->amount));

            $charge = Charge::create([
                'amount' => $amount ,
                'currency' => 'usd',
                'source' => $request->token,
                'description' => 'Test Payment',
            ]);

            if ($charge->status == 'succeeded') {
                $saleDeed = SaleDeedMain::where('HSD_ID', $request->id)->first(); //
  

                $paymentData = [
                    'transaction_id' => $charge->id,
                    'csparty_id' => null,
                    'plot_id' => null,
                    'amount' => $request->amount,
                    'payment_mod' => 'Credit Card',
                    'transaction_date' => now(),
                    'transaction_category' => 'installment',
                    'description' => $request->description,
                    'due_date' => $request->due_date,

                    'up_id' => $request->UP_ID,
                    'project_id' => '2000.2.1.6.8',
                    'hsd_id' => $saleDeed->HSD_ID,
                    'cust_id' => $saleDeed->Cust_ID,

                ];

                if (Payment::create($paymentData)) {

                    $installment = SaleDeedIns::find($request->inst_id);
                    $installment->status = 'paid';
                    $installment->save(); 
                    
                    // try {
                    //     $customer = CsParty::find($request->csparty_id);
                    //     Mail::to($customer->E_Mail)->send(new PaymentMail($customer));
                    // } catch (\Exception $e) {
                    //     \Log::error('Failed to send payment email: ' . $e->getMessage());
                    // }

                    return response()->json([
                        'success' => true,
                        'message' => 'installment paid successfully',
                        'payment_response' => $charge,
                    ]);
                } else {
                    return $this->errorInsertResponse();
                }
            } else {
                return response()->json([
                    'message' => 'Payment failed',
                    'payment_response' => $charge,
                ], 400);
            }
        } catch (\Exception $e) {
            Log::error('Payment processing error: ' . $e->getMessage());
            return response()->json([
                'message' => 'Server error',
                'errors' => $e->getMessage()
            ], 500);
        }
    }

   

    public function fetchInstallment(Request $request) // used on local server 
    {
        $data = Payment::select(
            'payments.cust_id as cust_no',
            'payments.up_id',
            'payments.project_id',
            'payments.hsd_id',
            'payments.amount',
            'payments.id as transactionId',
            'payments.description',
            'payments.due_date'
        )
            ->where('payments.transaction_category', 'installment')
            ->where('is_updateable', '1')->get();
        if (!$data->isEmpty()) {
            return response()->json([
                'data' => $data,
            ], 200);
        } else {
            return response()->json([
                'message' => 'no record found!',
            ], 404);
        }
    }


   





    public function fetchTokenTransactions(Request $request)
    {

        $data = Payment::select(
            'payments.id',
            'payments.plot_id as plot_no',
            'payments.amount',
            'payments.transaction_id',
            'payments.transaction_date',
            'csparty.Cust_Name as customer_name'
        )
            ->join('csparty', 'payments.csparty_id', 'csparty.id')
            ->where('payments.transaction_category', 'token')
            ->paginate(25);


        if (!$data->isEmpty()) {
            return response()->json([
                'data' => $data,
            ], 200);
        } else {
            return response()->json([
                'message' => 'no record found!',
            ], 404);
        }
    }

    public function fetchTokenTransactionsV1(Request $request)
    {
        $limit = $this->setDefaultValue($request->limit, DEFAULT_LIMIT);

        $data = Payment::select(
            'payments.id',
            'payments.plot_id',
            'payments.amount',
            'payments.transaction_id',
            'payments.transaction_date',
            'csparty.Cust_Name'
        )
            ->leftJoin('csparty', 'payments.csparty_id', 'csparty.id')
            ->where('payments.transaction_category', 'token')
            ->orderByDesc('id')
            ->paginate($limit);


        $pagination = [
            'page' => $data->currentPage(),
            'total_record' => $data->total(),
            'limit' => $limit,
            'total_pages' => ceil($data->total() / $limit),
        ];


        if (!$data->isEmpty()) {
            return response()->json([
                'data' => FetchTokenTransactionResource::collection($data->items()),
                'pagination' => $pagination
            ], 200);
        } else {
            return response()->json([
                'message' => 'No record found!'
            ], 404);
        }


    }


}